% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readerFuncs.R
\name{read_pot}
\alias{read_pot}
\title{A function to read .PT files}
\usage{
read_pot(station, loc_WinFapFiles = getwd(), getAmax = FALSE)
}
\arguments{
\item{station}{NRFA station number(s) for which the .PT file (names \code{station.PT}) should be read.}

\item{loc_WinFapFiles}{the file.path of the WINFAP files, i.e. the location in which the
\code{station.PT} file can be found. Default is the working directory}

\item{getAmax}{logical. If \code{TRUE} the annual maxima values (extracted from a \code{station.AM}
file) will be attached to the \code{WaterYearInfo} table}
}
\value{
a list of three objects \code{tablePOT}, \code{WaterYearInfo} and \code{dateRange}.

\code{tablePOT} contains a table with all the peaks above the threshold present in the .PT file

\code{WaterYearInfo} a table containing the information on the percentage of missing values
in any water year for which some data is available in the POT record. This is useful to assess
whether the lack of exceedances is genuine or the result of missing data and to assess whether the threshold
exceedances present in \code{tablePOT} can be deemed to be representative of the whole year

\code{dateRange} a vector with the first and last date of recording for the POT record as provided in the [POT Details] field.
Note that this period might be different than the period for which annual maxima records are available
}
\description{
The function reads .PT files once these are in a local folder: these files contain information on Peaks-Over-Threshold (POT) records from the instantaneous river flow measurements.
The function checks for the presence of any [POT GAPS] and [POT REJECTED] periods.
If these are present, they are merged and information on the proportion of days with missing records in each water year is provided.
}
\seealso{
Information on the .PT files and river flow gauging in the UK can be found at the National River Flow Archive website \url{https://nrfa.ceh.ac.uk}
}
