% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resist_gd.R
\name{get_resdist}
\alias{get_resdist}
\title{Get a matrix of resistance distances for \link[wingen]{resist_gd}}
\usage{
get_resdist(
  coords,
  lyr,
  fact = 0,
  transitionFunction = mean,
  directions = 8,
  geoCorrection = TRUE,
  coords_only = FALSE
)
}
\arguments{
\item{coords}{coordinates of samples as sf points, a two-column matrix, or a data.frame representing x and y coordinates (see Details for important information about projections)}

\item{lyr}{conductivity layer (higher values should mean greater conductivity) for generating distances. Can be either a SpatRaster or RasterLayer.}

\item{fact}{aggregation factor to apply to \code{lyr} (defaults to 0; \emph{note:} increasing this value reduces computational time)}

\item{transitionFunction}{function to calculate transition values from grid values (defaults to mean)}

\item{directions}{directions in which cells are connected (4, 8, 16, or other), see \link[raster]{adjacent} (defaults to 8)}

\item{geoCorrection}{whether to apply correction to account for local distances (defaults to TRUE). Geographic correction is necessary for all objects of the class Transition that are either: (1) based on a grid in a geographic (lonlat) projection and covering a large area; (2) made with directions > 4 (see \link[gdistance]{geoCorrection} for more details).}

\item{coords_only}{whether to return distances only for sample coordinates}
}
\value{
a distance matrix used by \link[wingen]{resist_gd}
}
\description{
Create a distance matrix based on coordinates and a connectivity layer.
The output is a distance matrix where rows represent cells on the landscape
and columns represent individual locations on the landscape. Each value is
the resistance distance between each sample and each cell calculated
using the gdistance package. This matrix is used by \link[wingen]{resist_gd}.
If coords_only = TRUE, the result is a distance matrix for the sample coordinates
only.
}
\examples{
load_mini_ex()
distmat <- get_resdist(mini_coords, mini_lyr)
}
