% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gd.R
\name{plot_count}
\alias{plot_count}
\title{Plot moving window map of sample counts}
\usage{
plot_count(
  x,
  index = NULL,
  breaks = 100,
  col = viridis::mako(breaks),
  main = NULL,
  box = FALSE,
  range = NULL,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{single SpatRaster of counts or SpatRaster where indexed layer is sample counts}

\item{index}{if a raster stack is provided, index of the sample count layer to plot
(defaults to plotting the layer named "sample_count" or the last layer of the stack)}

\item{breaks}{number of breaks to use in color scale (defaults to 10)}

\item{col}{color palette to use for plotting (defaults to viridis::magma palette)}

\item{main}{character. Main plot titles (one for each layer to be plotted). You can use arguments \code{cex.main}, \code{font.main}, \code{col.main} to change the appearance; and \code{loc.main} to change the location of the main title (either two coordinates, or a character value such as "topleft")}

\item{box}{whether to include a box around the raster plot (defaults to FALSE)}

\item{range}{numeric. minimum and maximum values to be used for the continuous legend}

\item{legend}{whether to include legend}

\item{...}{arguments passed to \code{plot("SpatRaster", "numeric")} and additional graphical arguments}
}
\value{
plot of sample counts
}
\description{
Plot sample counts layer produced by \link[wingen]{window_gd} or \link[wingen]{krig_gd}
}
\examples{
data("mini_lyr")
plot_count(mini_lyr)
}
