% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{wkb_translate_wkt}
\alias{wkb_translate_wkt}
\alias{wkb_translate_wkb}
\alias{wkb_translate_wksxp}
\alias{wkt_translate_wkt}
\alias{wkt_translate_wkb}
\alias{wkt_translate_wksxp}
\alias{wksxp_translate_wkt}
\alias{wksxp_translate_wkb}
\alias{wksxp_translate_wksxp}
\alias{wk_platform_endian}
\title{Translate between WKB and WKT}
\usage{
wkb_translate_wkt(
  wkb,
  include_z = NA,
  include_m = NA,
  include_srid = NA,
  precision = 16,
  trim = TRUE
)

wkb_translate_wkb(
  wkb,
  include_z = NA,
  include_m = NA,
  include_srid = NA,
  endian = wk_platform_endian(),
  buffer_size = 2048
)

wkb_translate_wksxp(wkb, include_z = NA, include_m = NA, include_srid = NA)

wkt_translate_wkt(
  wkt,
  include_z = NA,
  include_m = NA,
  include_srid = NA,
  precision = 16,
  trim = TRUE
)

wkt_translate_wkb(
  wkt,
  include_z = NA,
  include_m = NA,
  include_srid = NA,
  endian = wk_platform_endian(),
  buffer_size = 2048
)

wkt_translate_wksxp(wkt, include_z = NA, include_m = NA, include_srid = NA)

wksxp_translate_wkt(
  wksxp,
  include_z = NA,
  include_m = NA,
  include_srid = NA,
  precision = 16,
  trim = TRUE
)

wksxp_translate_wkb(
  wksxp,
  include_z = NA,
  include_m = NA,
  include_srid = NA,
  endian = wk_platform_endian(),
  buffer_size = 2048
)

wksxp_translate_wksxp(wksxp, include_z = NA, include_m = NA, include_srid = NA)

wk_platform_endian()
}
\arguments{
\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{\link[sf:st_as_binary]{sf::st_as_binary()}}.}

\item{include_z, include_m, include_srid}{Include the
values of the Z and M coordinates and/or SRID
in the output? Use \code{FALSE} to omit, \code{TRUE} to include, or \code{NA} to include
only if present. Note that using \code{TRUE} may result in an error if there
is no value present in the original.}

\item{precision}{The rounding precision to use when writing
(number of decimal places).}

\item{trim}{Trim unnecessary zeroes in the output?}

\item{endian}{For WKB writing, 0 for big endian, 1 for little endian.
Defaults to \code{\link[=wk_platform_endian]{wk_platform_endian()}} (slightly faster).}

\item{buffer_size}{For WKB writing, the initial buffer size to use for
each feature, in bytes. This will be extended when needed, but if you
are calling this repeatedly with huge geometries, setting this value
to a larger number may result in less copying.}

\item{wkt}{A character vector containing well-known text.}

\item{wksxp}{A \code{list()} of classed objects}
}
\value{
\verb{*_translate_wkt()} returns a character vector of
well-known text; \verb{*_translate_wkb()} returns a list
of raw vectors, and \verb{*_translate_wksxp()} returns an unclassed
list of \code{\link[=wksxp]{wksxp()}} geometries. Unlike \code{\link[=as_wkb]{as_wkb()}}, \code{\link[=as_wkt]{as_wkt()}}, and
\code{\link[=as_wksxp]{as_wksxp()}}, these functions do not attach
a class to the output.
}
\description{
Translate between WKB and WKT
}
\examples{
# translate between WKT and WKB
(wkb <- wkt_translate_wkb("POINT (30 10)"))
wkb_translate_wkt(wkb)

# some basic creation options are also available
wkt_translate_wkt("POINT (30 10)", trim = FALSE)
wkb_translate_wkb(wkb, endian = 0)

}
