% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wmm.R
\name{GetMagneticFieldWMM}
\alias{GetMagneticFieldWMM}
\title{Calculate Expected Magnetic Field from WMM}
\usage{
GetMagneticFieldWMM(lon, lat, height, time, wmmVersion = "derived")
}
\arguments{
\item{lon}{GPS longitude}

\item{lat}{GPS latitude, geodetic}

\item{height}{GPS height in meters above ellipsoid}

\item{time}{Annualized date time. E.g., 2015-02-01 = (2015 + 32/365) = 2015.088}

\item{wmmVersion}{String representing WMM version to use. Must be consistent with \code{time} and one of the following: 'derived', 'WMM2000', 'WMM2005', 'WMM2010', 'WMM2015', 'WMM2015v2'. Default 'derived' value will infer the latest WMM version consistent with \code{time}.}
}
\value{
list of calculated main field and secular variation vector components in nT and nT/yr, resp.: \code{x}, \code{y}, \code{z}, \code{xDot}, \code{yDot}, \code{zDot}
}
\description{
Function that takes in geodetic GPS location and annualized time, and returns the expected magnetic field from WMM.
}
\examples{
GetMagneticFieldWMM(
   lon = 240,
   lat = -80,
   height = 1e5,
   time = 2017.5,
   wmmVersion = 'WMM2015'
)

## Expected output
# X = 5683.51754 95763 nT
# Y = 14808.84920 23104 nT
# Z = -50163.01336 54779 nT

## Calculated Output
# X = 5683.518 nT
# Y = 14808.85 nT
# Z = -50163.01 nT
}
