% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_Adjacency.R
\name{PlotAdjacency}
\alias{PlotAdjacency}
\title{PlotAdjacency}
\usage{
PlotAdjacency(Wij, Visit = 1, stat = "mean",
  main = "Estimated Adjacencies", color.scheme = c("Black", "White"),
  edgewidth = 2, cornerwidth = 1/4, lwd.border = 3, color.bs = "gray",
  zlim = c(0, 1), legend = TRUE, DM = NULL, W = NULL)
}
\arguments{
\item{Wij}{a \code{\link{PosteriorAdj}} object.}

\item{Visit}{either an integer \code{(1,...,Nu)} indicating the visit number for which
you want to get the adjacencies to plot or NA. If NA, then the plot will produce the
dissimilarity metric at each adjacency.}

\item{stat}{either "mean" or "sd" (only used for Visit != NA).}

\item{main}{an overall title for the plot.}

\item{color.scheme}{a vector of colors to be used to show the adjacencies changing.}

\item{edgewidth}{a scalar indicating the width of the edges.}

\item{cornerwidth}{a scalar indicating the width of the corners.}

\item{lwd.border}{a scalar indicating width of the visual field border.}

\item{color.bs}{one color specifying the blind spot.}

\item{zlim}{the limits used for the legend (default are c(0,1)).}

\item{legend}{logical, indicating whether the legend should be present (default = TRUE).}

\item{DM}{a dissimilarity metric to be plotted at each location on the visual field (default = NULL).}

\item{W}{an adjacency matrix that specifies the visual field, required if Wij is not provided (default = NULL).}
}
\description{
Plots a heat map of the differential light sensitivity on the Humphrey Field
Analyzer-II visual field.
}
\details{
\code{PlotAdjacency} is used in the application of glaucoma progression to
 plot the posterior mean and standard deviation neighborhood adjacencies across the
 visual field.
}
\examples{
###Define blind spot locations on the HFA-II
blind_spot <- c(26, 35)

###Load visual field adjacency matrix
W <- HFAII_Queen[ -blind_spot, -blind_spot]

###Load Garway-Heath angles for dissimiliarity metric
DM <- GarwayHeath[-blind_spot] #Uses Garway-Heath angles object "GarwayHeath"

###Adjacency plots
PlotAdjacency(W = W, DM = DM, zlim = c(0, 180), Visit = NA,
              main = "Garway-Heath dissimilarity metric\\n across the visual field")

}
\author{
Samuel I. Berchuck
}

