#' lowbrth
#'
#' Data loads lazily. Type data(lowbrth) into the console.
#'
#' @docType data
#'
#' @usage data(lowbrth)
#'
#' @format A data.frame with 100 rows and 36 variables:
#' \itemize{
#'  \item year. 1987 or 1990
#'  \item lowbrth. perc births low weight
#'  \item infmort. infant mortality rate
#'  \item afdcprt. # participants in AFDC, 1000s
#'  \item popul. population, 1000s
#'  \item pcinc. per capita income
#'  \item physic. # physicians, 1000s
#'  \item afdcprc. percent of pop in AFDC
#'  \item d90. =1 if year == 1990
#'  \item lpcinc. log of pcinc
#'  \item cafdcprc. change in afdcprc
#'  \item clpcinc. change in lpcinc
#'  \item lphysic. log of physic
#'  \item clphysic. change in lphysic
#'  \item clowbrth. change in lowbrth
#'  \item cinfmort. change in infmort
#'  \item afdcpay. avg monthly AFDC payment
#'  \item afdcinc. afdcpay as percent pcinc
#'  \item lafdcpay. log of afdcpay
#'  \item clafdcpy. change in lafdcpay
#'  \item cafdcinc. change in afdcinc
#'  \item stateabb. state postal code
#'  \item state. name of state
#'  \item beds. # hospital beds, 1000s
#'  \item bedspc. beds per capita
#'  \item lbedspc. log(bedspc)
#'  \item clbedspc. change in lbedspc
#'  \item povrate. percent people below poverty line
#'  \item cpovrate. change in povrate
#'  \item afdcpsq. afdcper^2
#'  \item cafdcpsq. change in afdcpsq
#'  \item physicpc. physicians per capita
#'  \item lphypc. log(physicpc)
#'  \item clphypc. change in lphypc
#'  \item lpopul. log(popul)
#'  \item clpopul. change in lpopul
#' }
#' @source \url{https://www.cengage.com/cgi-wadsworth/course_products_wp.pl?fid=M20b&product_isbn_issn=9781111531041}
#' @examples  str(lowbrth)
"lowbrth"
 
 
