% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{run_game}
\alias{run_game}
\title{Run word puzzle game}
\usage{
run_game(mask_char = "_", verbose = TRUE, ...)
}
\arguments{
\item{mask_char}{(String) letter to mask the letters not guessed in the word.}

\item{verbose}{(Logical) whether to print welcome and score messages.}

\item{...}{For internal use only.}
}
\value{
Named list of game stats invisibly, including:
\describe{
\item{score}{Named integer with names as \code{success} (success rounds)
and \code{total} (total rounds).}
\item{best_guess}{Integer as the minimal number of guesses.}
\item{best_hit}{Named integer with names as \code{hit} (guesses that hit
any letters in the word) and \code{guess} (total guesses).}
}
}
\description{
\code{run_game} is the main function to run word puzzle game.
The word puzzle game requires you to guess the word with single letters
in a limited times of trials. The letters you have guessed in the word
reveal themselves. If all letters are revealed before your guesses run out,
you win this round, otherwise you fail.
}
\examples{
# Run word puzzle game
if (interactive() == TRUE) {
  run_game()
}
}
