% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordbankr.R
\name{get_datasets}
\alias{get_datasets}
\title{Get the Wordbank data sources}
\usage{
get_datasets(language = NULL, form = NULL, admin_data = FALSE, db_args = NULL)
}
\arguments{
\item{language}{An optional string specifying which language's datasets to
retrieve.}

\item{form}{An optional string specifying which form's datasets to retrieve.}

\item{admin_data}{A logical indicating whether to include summary-level
statistics on the administrations within a dataset.}

\item{db_args}{List with arguments to connect to wordbank mysql database
(host, dbname, user, and password).}
}
\value{
A data frame where each row is a particular dataset and its
  characteristics: \code{dataset_id}, \code{dataset_name},
  \code{dataset_origin_name} (unique identifier for groups of datasets that
  may share children), \code{language}, \code{form}, \code{form_type},
  \code{contributor} (contributor name and affiliated institution),
  \code{citation}, \code{license}, \code{longitudinal} (whether dataset
  includes longitudinal participants). Also includes summary statistics on a
  dataset if the \code{admin_data} flag is \code{TRUE}: number of
  administrations (\code{n_admins}).
}
\description{
Get the Wordbank data sources
}
\examples{
\donttest{
english_ws_datasets <- get_datasets(language = "English (American)",
                                    form = "WS",
                                    admin_data = TRUE)
}
}
