% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{Model}
\alias{Model}
\title{Represents n-gram models}
\description{
The Model class represents n-gram models. An instance of the class is a
single n-gram model. The attributes of this class are used to store n-gram
model information. The class provides methods for loading and saving the
model.
}
\details{
The attributes of this class are used to store n-gram model information such
as model name, model description, model file name, n-gram size, transition
probabilities data, default probability for words, data cleaning and
tokenization options, word list, model path, data directory path and
performance stats. The model is saved to a single file as a R object.

A model file contains all the information required by the model. The model
object is used as input by classes that perform operations on the model such
as evaluation of model performance, text predictions and comparison of model
performance.
}
\section{Super class}{
\code{\link[wordpredictor:Base]{wordpredictor::Base}} -> \code{Model}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pstats}}{The performance stats for the model.}

\item{\code{name}}{The model name.}

\item{\code{desc}}{The model description.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Model$new()}}
\item \href{#method-load_model}{\code{Model$load_model()}}
\item \href{#method-get_config}{\code{Model$get_config()}}
\item \href{#method-get_size}{\code{Model$get_size()}}
\item \href{#method-clone}{\code{Model$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
It initializes the current object. It is used to set the
maximum n-gram number, sample size, input file name, data cleaner
options, tokenization options, combined transition probabilities file
name and verbose.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$new(
  name = NULL,
  desc = NULL,
  fn = NULL,
  df = NULL,
  n = 4,
  ssize = 0.3,
  dir = ".",
  dc_opts = list(),
  tg_opts = list(),
  ve = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The model name.}

\item{\code{desc}}{The model description.}

\item{\code{fn}}{The model file name.}

\item{\code{df}}{The name of the file used to generate the model.}

\item{\code{n}}{The maximum n-gram number supported by the model.}

\item{\code{ssize}}{The sample size as a proportion of the input file.}

\item{\code{dir}}{The directory containing the model files.}

\item{\code{dc_opts}}{The data cleaner options.}

\item{\code{tg_opts}}{The token generator options.}

\item{\code{ve}}{The level of detail in the information messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_model"></a>}}
\if{latex}{\out{\hypertarget{method-load_model}{}}}
\subsection{Method \code{load_model()}}{
It loads the model using the given information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$load_model()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_config"></a>}}
\if{latex}{\out{\hypertarget{method-get_config}{}}}
\subsection{Method \code{get_config()}}{
It returns the given configuration data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_config(cn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cn}}{The name of the required configuration.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The configuration value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_size"></a>}}
\if{latex}{\out{\hypertarget{method-get_size}{}}}
\subsection{Method \code{get_size()}}{
It returns the size of the current object. The object
size is calculated as the sum of sizes of the object attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The size of the object in bytes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
