% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-wp-cat.R
\name{update_wp_cat}
\alias{update_wp_cat}
\title{Update a WordPress Category}
\usage{
update_wp_cat(
  domain,
  user,
  pass,
  tag_id,
  tag_name,
  tag_slug,
  tag_description,
  verbose = TRUE
)
}
\arguments{
\item{domain}{The domain on which you wish to update the given category.}

\item{user}{The username to be passed into the API call to update the category.}

\item{pass}{The password to be used in the API call to update the category. To get this value,
you must have the Application Passwords plugin
installed, and must create an application using that plugin via your WordPress admin panel;
there you will get the password needed.}

\item{tag_id}{The ID of the category desired to be updated in the WordPress site's database.}

\item{tag_name}{The desired name of the category that users will see on the WordPress site.}

\item{tag_slug}{The slug to be associated with the WordPress category. Change with caution, as
changing the slug may result in URLs being broken.}

\item{tag_description}{The description of the category; this value will be used wherever the
description of the WordPress category is used (perhaps in your theme).}

\item{verbose}{Defaults to TRUE; determines whether or not the desired category name and slug
will be printed in the console. Potentially useful if employing this function in a loop in
which many categories will be updated at once.}
}
\value{
response from the API. 200 means success -- the category was updated!
}
\description{
Update the name, description, or slug of a category in your WordPress site.
}
\examples{
\dontrun{
update_wp_cat(root_url = 'https://domain.com',user = Sys.getenv('username'),
pass = Sys.getenv('password'),
tag_name = 'cool posts',description_text = 'this is the description text for the category
"very cool posts". ')
}

}
