% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_start.R
\name{wflow_start}
\alias{wflow_start}
\title{Start a new workflowr project}
\usage{
wflow_start(directory, name = NULL, git = TRUE, existing = FALSE,
  overwrite = FALSE, change_wd = TRUE, user.name = NULL,
  user.email = NULL)
}
\arguments{
\item{directory}{character. The directory for the project, e.g.
"~/new-project". When \code{existing = FALSE}, the directory will
be created.}

\item{name}{character (default: NULL). Project name, e.g. "My Project". When
\code{name = NULL}, the project name is automatically set based on the
argument \code{directory}. For example, if \code{directory =
"~/projects/myproject"}, then \code{name} is set to \code{"myproject"}.
\code{name} is displayed on the site's navigation bar and the README.md.}

\item{git}{logical (default: TRUE). Should Git be used for version
control? If \code{directory} is a new Git repository and \code{git
= TRUE}, \code{wflow_start} will initialize the repository and make
an initial commit. If \code{git = TRUE} and \code{directory} is
already a Git repository, \code{wflow_start} will make an
additional commit. In both cases, only files needed for the
workflowr project will be included in the commit.}

\item{existing}{logical (default: FALSE). Indicate if the specified
\code{directory} already exists. The default prevents injecting the
workflowr files into an unwanted location. Only set to TRUE if you wish to
add the workflowr files to an existing project.}

\item{overwrite}{logical (default: FALSE). Control whether to overwrite
existing files. Only relevant if \code{existing = TRUE}.}

\item{change_wd}{logical (default: TRUE). Change the working directory to the
\code{directory}.}

\item{user.name}{character (default: NULL). The user name used by Git to sign
commits, e.g. "My Name". This setting will only apply to this specific
workflowr project being created. To create a Git user name to apply to all
workflowr projects (and Git repositories) on this computer, instead use
\code{\link{wflow_git_config}}.}

\item{user.email}{character (default: NULL). The email addresse used by Git
to sign commits, e.g. "email@domain". This setting will only apply to this
specific workflowr project being created. To create a Git email address to
apply to all workflowr projects (and Git repositories) on this computer,
instead use \code{\link{wflow_git_config}}.}
}
\value{
Invisibly returns absolute path to workflowr project.
}
\description{
\code{wflow_start} creates a minimal workflowr project. The default
behaviour is to add these files to a new directory, but it is also
possible to populate an already existing project. By default, it
also changes the working directory to the workflowr project.
}
\details{
This is the initial function that organizes the infrastructure to
create a research website for your project. Note that while you do
not need to use RStudio with workflowr, do not delete the Rproj
file because it is required by other functions.
}
\examples{
\dontrun{

wflow_start("path/to/new-project")

# Provide a custom name for the project.
wflow_start("path/to/new-project", name = "My Project")

# Add workflowr files to an existing project.
wflow_start("path/to/current-project", existing = TRUE)

# Add workflowr files to an existing project, but do not automatically
# commit them.
wflow_start("path/to/current-project", git = FALSE, existing = TRUE)
}
}
\seealso{
vignette("wflow-01-getting-started")
}
