% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_use_github.R
\name{wflow_use_github}
\alias{wflow_use_github}
\title{Deploy site with GitHub}
\usage{
wflow_use_github(username = NULL, repository = NULL,
  navbar_link = TRUE, create_on_github = NULL, protocol = "https",
  domain = "github.com", project = ".")
}
\arguments{
\item{username}{character (default: NULL). The GitHub account associated with
the GitHub repository. This is likely your personal GitHub username, but it
could also be the name of a GitHub organization you belong to. It will be
combined with the arguments \code{repository} and \code{domain} to
determine the URL of the new repository, e.g. the default is
https://github.com/username/repository. It will be combined with the
arguments \code{repository}, \code{domain}, and \code{protocol} to
determine the URL for Git to use to push and pull from GitHub, e.g. the
default is https://github.com/username/repository.git. If \code{username}
is not specified, \code{wflow_use_github} will first attempt to guess it
from the current setting for the remote URL named "origin". If you haven't
previously configured a remote for this workflowr project (or you are
unsure what that means), then you should specify your GitHub username when
calling this function.}

\item{repository}{character (default: NULL). The name of the remote
repository on GitHub. If not specified, workflowr will guess the name of
the repository. First, it will check the current setting for the remote URL
named "origin". Second, it will use the name of the root directory of the
workflowr project.}

\item{navbar_link}{logical (default: TRUE). Insert a link to the GitHub
repository into the navigation bar.}

\item{create_on_github}{logical (default: NULL). Should workflowr create the
repository on GitHub? This requires logging into your GitHub account to
authenticate workflowr to act on your behalf. The default behavior is to
ask the user. Note that this only works for public repositories on
github.com. If you want to create a private repository or are using GitHub
Enterprise, you will need to manually create the repository.}

\item{protocol}{character (default: "https"). The protocol for communicating
with GitHub. Must be either "https" or "ssh".}

\item{domain}{character (default: "github.com"). The domain of the remote
host. You only need to change this if your organization is using GitHub
Enterprise.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Invisibly returns a list of class \code{wflow_use_github}. This is
  currently for internal use only. Please open an Issue if you'd like to use
  this information.
}
\description{
\code{wflow_use_github} automates all the local configuration necessary to
deploy your workflowr project with \href{https://pages.github.com/}{GitHub
Pages}. Optionally, it can also create the new repository on GitHub and push
the files to GitHub (only applies to public repositories hosted on
github.com).
}
\details{
\code{wflow_use_github} performs the following steps and then commits the
changes:

\itemize{

\item Adds a link to the GitHub repository in the navigation bar

\item Configures the Git remote settings to use GitHub (via
\code{\link{wflow_git_remote}})

\item (Only if necessary) Renames the website directory to \code{docs/}

\item (Only if necessary) Edits the setting \code{output_dir} in the file
\code{_site.yml} to save the website files in \code{docs/}

}

Furthermore, \code{wflow_use_github} will prompt you to request permission to
perform the following steps:

\itemize{

\item (Optional) Creates the new repository on GitHub. If you accept, your
browser will open for you to provide authorization. If you are not logged
into GitHub, you will be prompted to login. Then you will be asked to give
permission to the workflowr-oauth-app to create the new repository for you on
your behalf. This will allow \code{wflow_use_github}, running on your own
machine, to create your new repository. Once \code{wflow_use_github}
finishes, workflowr can no longer access your GitHub account.

\item (Optional) Pushes the files to GitHub (via
\code{\link{wflow_git_push}}). Don't worry if this step fails. If it does,
run \code{git push origin master} in your terminal.

}

If you choose to not allow workflowr to create the repository for you, then
you will have to complete these final two steps manually. First, login to
your account and create the new repository on GitHub. Second, run
\code{wflow_git_push} in the R console or \code{git push origin master}.
}
\examples{
\dontrun{

wflow_use_github("your-username", "name-of-repository")
# Login with GitHub account and create new repository
wflow_git_push()
}

}
\seealso{
\code{\link{wflow_git_push}}, \code{\link{wflow_git_remote}},
         \code{\link{wflow_use_gitlab}}
}
