% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_site.R
\name{wflow_site}
\alias{wflow_site}
\title{Custom site generator for workflowr websites}
\usage{
wflow_site(input, encoding = getOption("encoding"), ...)
}
\arguments{
\item{input}{character. The name of the website directory or a specific R
Markdown file in the website directory.}

\item{encoding}{character. The
\href{https://en.wikipedia.org/wiki/Character_encoding}{character encoding}
to use to read the file.}

\item{...}{Placeholder for potential future use.}
}
\description{
\code{wflow_site} is a
\href{http://rmarkdown.rstudio.com/rmarkdown_site_generators.html}{custom
site generator} to be used in combination with the R Markdown output format
\code{\link{wflow_html}}.
}
\details{
Do not call the function \code{wflow_site} directly. Instead insert the line
below directly into the YAML header of the file \code{index.Rmd}:

\preformatted{
---
title: "Home"
site: workflowr::wflow_site
output:
  workflowr::wflow_html:
    toc: false
---
}

Then you can build the website by running \code{\link[rmarkdown]{render_site}}
in the R console or clicking the Knit button in RStudio.

If you receive an error when using the RStudio Knit button (the error is
about an unused argument), make sure the Knit Directory is set to Document
Directory (you can set this with the dropdown menu next to the Knit button).
}
\seealso{
\code{\link{wflow_html}}, \code{\link[rmarkdown]{render_site}}
}
