% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{workflow-extractors}
\alias{workflow-extractors}
\alias{pull_workflow_preprocessor}
\alias{pull_workflow_spec}
\alias{pull_workflow_fit}
\alias{pull_workflow_mold}
\alias{pull_workflow_prepped_recipe}
\title{Extract elements of a workflow}
\usage{
pull_workflow_preprocessor(x)

pull_workflow_spec(x)

pull_workflow_fit(x)

pull_workflow_mold(x)

pull_workflow_prepped_recipe(x)
}
\arguments{
\item{x}{A workflow}
}
\value{
The extracted value from the workflow, \code{x}, as described in the description
section.
}
\description{
These functions extract various elements from a workflow object. If they do
not exist yet, an error is thrown.
\itemize{
\item \code{pull_workflow_preprocessor()} returns the formula, recipe, or variable
expressions used for preprocessing.
\item \code{pull_workflow_spec()} returns the parsnip model specification.
\item \code{pull_workflow_fit()} returns the parsnip model fit.
\item \code{pull_workflow_mold()} returns the preprocessed "mold" object returned
from \code{\link[hardhat:mold]{hardhat::mold()}}. It contains information about the preprocessing,
including either the prepped recipe or the formula terms object.
\item \code{pull_workflow_prepped_recipe()} returns the prepped recipe. It is
extracted from the mold object returned from \code{pull_workflow_mold()}.
}
}
\examples{
library(parsnip)
library(recipes)
library(magrittr)

model <- linear_reg() \%>\%
  set_engine("lm")

recipe <- recipe(mpg ~ cyl + disp, mtcars) \%>\%
  step_log(disp)

base_wf <- workflow() \%>\%
  add_model(model)

recipe_wf <- add_recipe(base_wf, recipe)
formula_wf <- add_formula(base_wf, mpg ~ cyl + log(disp))
variable_wf <- add_variables(base_wf, mpg, c(cyl, disp))

fit_recipe_wf <- fit(recipe_wf, mtcars)
fit_formula_wf <- fit(formula_wf, mtcars)

# The preprocessor is a recipes, formula, or a list holding the
# tidyselect expressions identifying the outcomes/predictors
pull_workflow_preprocessor(recipe_wf)
pull_workflow_preprocessor(formula_wf)
pull_workflow_preprocessor(variable_wf)

# The `spec` is the parsnip spec before it has been fit.
# The `fit` is the fit parsnip model.
pull_workflow_spec(fit_formula_wf)
pull_workflow_fit(fit_formula_wf)

# The mold is returned from `hardhat::mold()`, and contains the
# predictors, outcomes, and information about the preprocessing
# for use on new data at `predict()` time.
pull_workflow_mold(fit_recipe_wf)

# A useful shortcut is to extract the prepped recipe from the workflow
pull_workflow_prepped_recipe(fit_recipe_wf)

# That is identical to
identical(
  pull_workflow_mold(fit_recipe_wf)$blueprint$recipe,
  pull_workflow_prepped_recipe(fit_recipe_wf)
)
}
