% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_workflow_set_result}
\alias{extract_workflow_set_result}
\alias{extract_workflow.workflow_set}
\alias{extract_spec_parsnip.workflow_set}
\alias{extract_recipe.workflow_set}
\alias{extract_fit_parsnip.workflow_set}
\alias{extract_fit_engine.workflow_set}
\alias{extract_mold.workflow_set}
\alias{extract_preprocessor.workflow_set}
\title{Extract elements of workflow sets}
\usage{
extract_workflow_set_result(x, id, ...)

\method{extract_workflow}{workflow_set}(x, id, ...)

\method{extract_spec_parsnip}{workflow_set}(x, id, ...)

\method{extract_recipe}{workflow_set}(x, id, ..., estimated = TRUE)

\method{extract_fit_parsnip}{workflow_set}(x, id, ...)

\method{extract_fit_engine}{workflow_set}(x, id, ...)

\method{extract_mold}{workflow_set}(x, id, ...)

\method{extract_preprocessor}{workflow_set}(x, id, ...)
}
\arguments{
\item{x}{A workflow set.}

\item{id}{A single character string for a workflow ID.}

\item{...}{Other options (not currently used).}

\item{estimated}{A logical for whether the original (unfit) recipe or the
fitted recipe should be returned.}
}
\value{
The extracted value from the object, \code{x}, as described in the
description section.
}
\description{
These functions extract various elements from a workflow set object. If they
do not exist yet, an error is thrown.
\itemize{
\item \code{extract_preprocessor()} returns the formula, recipe, or variable
expressions used for preprocessing.
\item \code{extract_spec_parsnip()} returns the parsnip model specification.
\item \code{extract_fit_parsnip()} returns the parsnip model fit object.
\item \code{extract_fit_engine()} returns the engine specific fit embedded within
a parsnip model fit. For example, when using \code{\link[parsnip:linear_reg]{parsnip::linear_reg()}}
with the \code{"lm"} engine, this returns the underlying \code{lm} object.
\item \code{extract_mold()} returns the preprocessed "mold" object returned
from \code{\link[hardhat:mold]{hardhat::mold()}}. It contains information about the preprocessing,
including either the prepped recipe, the formula terms object, or
variable selectors.
\item \code{extract_recipe()} returns the recipe. The \code{estimated} argument specifies
whether the fitted or original recipe is returned.
\item \code{extract_workflow_set_result()} returns the results of \code{\link[=workflow_map]{workflow_map()}}
for a particular workflow.
\item \code{extract_workflow()} returns the workflow object. The workflow will not
have been estimated.
}
}
\details{
These functions supersede the \verb{pull_*()} functions (e.g.,
\code{\link[=extract_workflow_set_result]{extract_workflow_set_result()}}).
}
\examples{
library(tune)

extract_workflow_set_result(two_class_res, "none_cart")

extract_workflow(two_class_res, "none_cart")
}
