% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip.R
\name{pip_aux}
\alias{pip_aux}
\title{Return auxiliary data tables}
\source{
\url{https://pip.worldbank.org/api}
}
\usage{
pip_aux(
  table = NULL,
  release_version = NULL,
  ppp_version = NULL,
  version = NULL
)
}
\arguments{
\item{table}{\code{character(1)} table to be returned. Default \code{NULL}.}

\item{release_version}{\code{character(1)} version of the data release in YYYYMMDD format.
Default \code{NULL}.}

\item{ppp_version}{\code{character(1)} | \code{numeric(1)} version of the data. Default \code{NULL}.}

\item{version}{\code{character(1)} version of the data. Default \code{NULL}.}
}
\value{
A \code{character()} with the available tables or a \code{data.frame()} containing the
table data.
}
\description{
Return auxiliary data tables
}
\examples{
\donttest{
# get a list of available tables
pip_aux()

# get countries
pip_aux("countries")

# get GDP
pip_aux("gdp")

# get CPI
pip_aux("cpi")
}
}
\seealso{
Other poverty and inequality statistics: 
\code{\link{pip_citation}()},
\code{\link{pip_data}()},
\code{\link{pip_group}()},
\code{\link{pip_health_check}()},
\code{\link{pip_info}()},
\code{\link{pip_valid_params}()},
\code{\link{pip_versions}()}
}
\concept{poverty and inequality statistics}
