% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_player_scouting.R
\name{fb_player_scouting_report}
\alias{fb_player_scouting_report}
\title{Get fbref Full Player Scouting Report}
\usage{
fb_player_scouting_report(player_url, pos_versus, time_pause = 3)
}
\arguments{
\item{player_url}{the URL of the player (can come from fb_player_urls())}

\item{pos_versus}{either "primary" or "secondary" as fbref offer comparisons against multiple positions}

\item{time_pause}{the wait time (in seconds) between page loads}
}
\value{
returns a dataframe of a player's full scouting information for all seasons available on FBref
}
\description{
Returns the scouting report for a selected player
}
\examples{
\dontrun{
try({
fb_player_scouting_report(player_url = "https://fbref.com/en/players/d70ce98e/Lionel-Messi",
pos_versus = "primary")

# to filter for the last 365 days:
fb_player_scouting_report(player_url = "https://fbref.com/en/players/d70ce98e/Lionel-Messi",
pos_versus = "primary") \%>\% dplyr::filter(scouting_period == "Last 365 Days")

# to get secondary positions
fb_player_scouting_report(player_url = "https://fbref.com/en/players/d70ce98e/Lionel-Messi",
pos_versus = "secondary")

# for the 2020-2021 La Liga season
fb_player_scouting_report(player_url = "https://fbref.com/en/players/d70ce98e/Lionel-Messi",
pos_versus = "secondary") \%>\% dplyr::filter(scouting_period == "2020-2021 La Liga")
})
}
}
