% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_distribution.R
\name{wm_distribution}
\alias{wm_distribution}
\alias{wm_distribution_}
\title{Get distribution data by AphiaID}
\usage{
wm_distribution(id, ...)

wm_distribution_(id = NULL, name = NULL, ...)
}
\arguments{
\item{id}{(numeric/integer) an AphiaID. For \code{wm_distribution} it's
required and must be \code{length(id) == 1}, for \code{wm_distribution_} it's
optional and can be \code{length(id) >= 1}}

\item{...}{named curl options. see \code{curl::curl_options}}

\item{name}{(character) one or more taxonomic names. optional}
}
\value{
A tibble/data.frame. when using underscore method, outputs from
each input are binded together, but can be split by \code{id} column
}
\description{
Get distribution data by AphiaID
}
\section{Singular vs. plural}{

Of the two sister functions, the one without the underscore is the original
function that wraps the relavant WoRMS API method - and only accepts
one thing (i.e., name or AphiaID) per request.

The sister function with the underscore at the end is the plural version,
accepting more than one input. Internally this function loops over
the non-underscore method, and labels output (whether it's a list or
data.frame rows) with the input names or IDs so that you can easily
parse output by your inputs.
}

\examples{
\dontrun{
wm_distribution(id = 156806)
wm_distribution(id = 126436)

wm_distribution_(id = c(156806, 126436))
}
}
