% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/givens_path.R
\name{guided_tour_givens}
\alias{guided_tour_givens}
\title{Create a guided tour with Givens interpolation}
\usage{
guided_tour_givens(
  index_f,
  d = 2,
  alpha = 0.5,
  cooling = 0.99,
  max.tries = 25,
  max.i = Inf,
  optim = "search_geodesic",
  n_sample = 100,
  ...
)
}
\arguments{
\item{index_f}{the index function to optimize.}

\item{d}{target dimensionality}

\item{alpha}{the initial size of the search window, in radians}

\item{cooling}{the amount the size of the search window should be adjusted
by after each step}

\item{max.tries}{the maximum number of unsuccessful attempts to find
a better projection before giving up}

\item{max.i}{the maximum index value, stop search if a larger value is found}

\item{optim}{character indicating the search strategy to use: \code{search_geodesic}, \code{search_better},
\code{search_better_random}, \code{search_polish}. Default is \code{search_geodesic}.}

\item{n_sample}{number of samples to generate if \code{search_f} is \code{search_polish}}

\item{...}{arguments sent to the search_f}
}
\value{
creates guided tour
}
\description{
Create a guided tour with Givens interpolation
}
\examples{
data(sine_curve)
tourr::animate_xy(sine_curve, guided_tour_givens(tourr::splines2d()), sphere=FALSE)
}
