% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_query.R
\name{identify_query}
\alias{identify_query}
\title{Identify the query type of the passed data frame}
\usage{
identify_query(data, threshold = 2)
}
\arguments{
\item{data}{A Workplace Analytics dataset in the form of a data frame.
If the data is not identified as a Workplace Analytics dataset, the function
will return an error.}

\item{threshold}{Debugging use only. Increase to raise the 'strictness' of
the guessing algorithm. Defaults to 2.}
}
\value{
String. A diagnostic message is returned.
}
\description{
Pass a Workplace Analytics dataset and return the identified
query type as a string. This function uses variable name string
matching to 'guess' the query type of the data frame.
}
\examples{
identify_query(sq_data) # Standard query
identify_query(mt_data) # Meeting query
identify_query(em_data) # Hourly collaboration query
\dontrun{
identify_query(iris) # Will return an error
identify_query(mtcars) # Will return an error
}
}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate_report}()},
\code{\link{subject_validate}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}
}
\concept{Data Validation}
