% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBagPlot.R
\name{addBagPlot}
\alias{addBagPlot}
\title{Add bagplot to existing plot}
\usage{
addBagPlot(
  x,
  lev1 = 0.5,
  outCoef = 2,
  bagCol = NULL,
  bagCont = bagCol,
  bagLwd = 1.5,
  nCore = 4,
  outlCol = 2,
  outlPch = NULL,
  outlCex = 0.6,
  reCol = NULL,
  rePch = NULL,
  reCex = NULL,
  ctrPch = NULL,
  ctrCol = NULL,
  ctrCex = NULL,
  addSubTi = TRUE,
  returnOutL = FALSE,
  callFrom = NULL,
  silent = TRUE
)
}
\arguments{
\item{x}{(matrix, list or data.frame) main numeric input of data/points to plot}

\item{lev1}{(numeric) min content of data for central area (default 0.5 for 50 percent)}

\item{outCoef}{(numeric) parameter for defining outliers (equivalent to \code{range} in \code{\link[graphics]{boxplot}})}

\item{bagCol}{(character or integer) color for filling center part of bagplot (default light transparent grey); Note: It is highly suggested to use transparency, otherwise points underneith will be covered}

\item{bagCont}{(character) color for inner and outer contours of bagplot}

\item{bagLwd}{(numeric) line width for outer contour, set to \code{NULL} for not diaplaying outer contour (see also \code{\link[graphics]{par}})}

\item{nCore}{(integer) decide when center should be determined by median or mean: if number of points reach \code{nCore} the median will be used}

\item{outlCol}{(character or integer) color for highlighting outlyers (for text and replottig outlyers points), set to \code{NULL} for not highlighting outlyers at all}

\item{outlPch}{(integer) symbol replotting highlighted outlyers (for text and replottig outlyers points), set to \code{NULL} for not replotting outlyer-points (see also \code{\link[graphics]{par}})}

\item{outlCex}{(numeric) cex type expansion factor for labels of highlighted outlyers, set to \code{NULL} for not printing (row)names of outlyers (see also \code{\link[graphics]{par}})}

\item{reCol}{(character or integer) color for replotting (non-outlyer) points, default set to \code{NULL} for not replotting}

\item{rePch}{(integer) symbol for replotting (non-outlyer) points, default set to \code{NULL} for not re-plotting (see also \code{\link[graphics]{par}})}

\item{reCex}{(numeric) cex type expansion factor for lfor replotting (non-outlyer) points, default set to \code{NULL} for not replotting}

\item{ctrPch}{(integer) symbol for showing group center (see also \code{\link[graphics]{par}})}

\item{ctrCol}{(character or integer) color for group center symbol}

\item{ctrCex}{(numeric) cex type expansion factor for size of group center (see also \code{\link[graphics]{par}})}

\item{addSubTi}{(logical) decide if subtitle (stating that potential outlyers were displayed separatetly) should be added in plot}

\item{returnOutL}{(logical) decide if rownames of (potential) outlyer values should be returned when running the function}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{silent}{(logical) suppress messages}
}
\value{
plot, optional return of matrix with outlyers
}
\description{
This function adds a bagplot on an existing (scatter-)plot allowing to highlight the central area of the data.
Briefly, a bagplot is a bivariate boxplot, see \href{https://en.wikipedia.org/wiki/Bagplot}{Bagplot}, following the basic idea of a boxplot in two dimensions.
Of course, multimodal distributions - if not separated first - may likely lead to mis-interpretation, similarly as it is known for interpreting boxplots.
If a group of data consists only of 2 data-points, they will be conected using a straight line.
It is recommended using transparent colors to highlight the core part of a group (if only 2 points are available, they will be conected using a straight line),
in addition, one could use the option to re-plot all (non-outlyer) points (arguments \code{reCol}, \code{rePch} and \code{reCex} must be used).
}
\examples{
set.seed(2020); dat1 <- matrix(round(rnorm(2000),3),ncol=2); rownames(dat1) <- 1:nrow(dat1)
dat1 <- dat1+ 5*matrix(rep(c(0,1,1,0,0,0,1,1),nrow(dat1)/4), byrow=TRUE, ncol=2)
col1 <- rgb(red=c(153,90,203,255), green=c(143,195,211,125), blue=c(204,186,78,115),
  alpha=90, maxColorValue=255)
## suppose we know the repartition into 4 subgroups which we would like to highlight them
grp1 <- rep(1:4, nrow(dat1)/4)
plot(dat1, col=grey(0.8), xlab="x", ylab="y", las=1, pch=grp1)
for(i in 1:4) addBagPlot(dat1[which(grp1==i),], bagCol=col1[i])
## slightly improved
library(wrMisc)
col2 <- convColorToTransp(col1, 255)
plot(dat1, col=grey(0.8), xlab="x", ylab="y", las=1, pch=grp1)
for(i in 1:4) addBagPlot(dat1[which(grp1==i),], bagCol=col1[i], outlPch=i,
  outlCol=col2[i], bagLwd=3)
}
\seealso{
\code{\link{plotPCAw}}, \code{\link[stats]{princomp}}
}
