% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test2factLimma.R
\name{test2factLimma}
\alias{test2factLimma}
\title{2-factorial limma-style t-test}
\usage{
test2factLimma(datMatr, fac1, fac2, testSynerg = TRUE,
  testOrientation = "=", addResults = c("lfdr", "FDR", "Mval",
  "means"), addGenes = NULL, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{datMatr}{matrix or data.frame with lines as indenpendent series of measures (eg different genes)}

\item{fac1}{(character or factor) vector describing grouping elements of each line of 'datMatr' for first factor, must be of same langth as fac2}

\item{fac2}{(character or factor) vector describing grouping elements of each line of 'datMatr' for second factor, must be of same langth as fac1}

\item{testSynerg}{(logical) decide if factor-interactions (eg synergy) should be included to model}

\item{testOrientation}{(character) default (or any non-recignized input) '=', otherwise either '>','gerater','sup','upper' or '<','inf','lower'}

\item{addResults}{(character) vector defining which types of information should be included to output, may be 'lfdr','FDR' (for BY correction), 'Mval' (M values), 'means' (matrix with mean values for each group of replicates)}

\item{addGenes}{(matrix or data.frame) additional information to add to output}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
object of class "MArrayLM" (from limma)
}
\description{
\code{test2factLimma} runs 2 fact test on data 'datMatr' which should already be organized as matrix (rows = genes) using \code{\link[limma]{eBayes}}
Note: this function uses the Bioconductor package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma}
}
\examples{
## example for testing change of ratio for 4 sets (AA-DD) of pairs of data  
set.seed(2017); t8 <- matrix(round(rnorm(160,10,0.4),2),ncol=8,
  dimnames=list(letters[1:20],c("AA1","BB1","CC1","DD1","AA2","BB2","CC2","DD2")))
t8[3:6,1:2] <- t8[3:6,1:2]+3   # augment lines 3:6 (c-f) for AA1&BB1
t8[5:8,5:6] <- t8[5:8,5:6]+3   # augment lines 5:8 (e-h) for AA2&BB2 (c,d,g,h should be found)
## via MAobj
maOb8 <- makeMAList(t8,MAf=gl(2,4,labels=c("R","G")))
fit8b <- test2factLimma(maOb8,c(1,1,1,1),c(0,0,1,1),testS=FALSE)  # same result as fit8e
limma::topTable(fit8b,coef=1,n=5)                      # effect for c,d,g&h
## explicit (long) way via limma:
fit8 <- limma::lmFit(maOb8, design= model.matrix(~ 0+factor(c(1,1,2,2))))
fit8e <- limma::eBayes(fit8)
limma::topTable(fit8e,coef=1,n=5)                      # effect for c,d,g&h
}
\seealso{
single line testing \code{\link[limma]{eBayes}}, for single line testing without eBayes see \code{\link{test2factLimma}}
}
