% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBeforFileExtension.R
\name{addBeforFileExtension}
\alias{addBeforFileExtension}
\title{Add text before file-extension}
\usage{
addBeforFileExtension(
  x,
  add,
  sep = "_",
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{x}{main character vector}

\item{add}{character vector to be added}

\item{sep}{(character) separator between 'x' & 'add' (character, length 1)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}
}
\value{
modified character vector
}
\description{
This function helps changing charater srings like file-names and allows adding the character vector 'add'
(length 1) before the extension (defined by last '.') of the input string 'x'. 
Used for easily creating variants/additional filenames but keeping current extension.
}
\examples{
addBeforFileExtension(c("abd.txt","ghg.ijij.txt","kjh"),"new")
}
