% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinatIntTable.R
\name{combinatIntTable}
\alias{combinatIntTable}
\title{Planing for making all multiplicative combinations}
\usage{
combinatIntTable(
  nMax,
  include0 = TRUE,
  asList = FALSE,
  callFrom = NULL,
  silent = TRUE
)
}
\arguments{
\item{nMax}{(positive integer) could be max number of voting participants form different cities, eg Paris max 2 persons, Lyon max 1 person ...}

\item{include0}{(logical) include 0 occurances, ie provide al combinations starting from 0 or from 1 up to nMax}

\item{asList}{(logical) return result as list or as array}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{silent}{(logical) suppress messages}
}
\value{
list or array (as 2- or 3 dim) with possible number of occurances for each of the 3 elements in nMax. Read results vertical : out[[1]] or out[,,1] .. (multiplicative) table for 1st element of nMax; out[,,2] .. for 2nd
}
\description{
Provide all combinations for each of n elements of vector 'nMax' (positive integer, eg number of max multiplicative value). 
For example, imagine, we have 3 cities and the (maximum) voting participants per city.
Results must be read vertically and allow to see all total possible compositons.
}
\examples{
combinatIntTable(c(1,1,1,2), include0=TRUE, asList=FALSE, silent=TRUE)
## Imagine we have 3 cities and the (maximum) voting participants per city :
nMa <- c(Paris=2, Lyon=1, Strasbourg=1)
combinatIntTable(nMa, include0=TRUE, asList=TRUE, silent=TRUE) 
}
\seealso{
\code{\link[utils]{combn}}
}
