% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract1chan.R
\name{extr1chan}
\alias{extr1chan}
\title{Extract just one series, ie channel, of list of arrays}
\usage{
extr1chan(arrLst, cha, na.rm = TRUE, rowSep = "__")
}
\arguments{
\item{arrLst}{(list) list of arrays (typically 1st and 2nd dim for specific genes/objects, 3rd for different measures associated with)}

\item{cha}{(integer) channel number}

\item{na.rm}{(logical) default =TRUE to remove NAs}

\item{rowSep}{(character) separator for rows}
}
\value{
list with just single channel extracted
}
\description{
This function was designed for handeling measurements stored as list of multiple arrays, like eg compound-screens using microtiter-plates where multiple parameters ('channels') 
were recorded for each well (element).
The elements (eg compounds screened) are typcally stored in the 1st dimension of the arrays, the replicated in the secon dimension and different measure types/parameters in the 3rd chanel. 
In order to keep the structure of of individual microtiter-plates, typically each plate forms a separate array (of same dimensions) in a list.  
The this function allows extracting a single channel of the list of arrays (3rd dim of each array) and return row-appended matrix.
}
\examples{
arr1 <- array(1:24,dim=c(4,3,2),dimnames=list(c(LETTERS[1:4]),
  paste("col",1:3,sep=""),c("ch1","ch2")))
arr2 <- array(74:51,dim=c(4,3,2),dimnames=list(c(LETTERS[1:4]),
  paste("col",1:3,sep=""),c("ch1","ch2")))
arrL1 <- list(pl1=arr1,pl2=arr2)
extr1chan(arrL1,ch=2)
}
\seealso{
\code{\link[wrMisc]{organizeAsListOfRepl}}
}
