% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findUsableGroupRange.R
\name{findUsableGroupRange}
\alias{findUsableGroupRange}
\title{Select groups within given range}
\usage{
findUsableGroupRange(dat, grp, maxNA = 1, callFrom = NULL)
}
\arguments{
\item{dat}{(matrix or data.frame) main input}

\item{grp}{(factor) information which column of 'dat' is replicate of whom}

\item{maxNA}{(interger) max number of tolerated NAs}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix with boundaries of 1st and last usable column (NA if there were no suitable groups found)
}
\description{
This function aims to help finding streches/segments of data with a given maximum number of NA-instances.
This function is used to inspect/filter each lines of 'dat' for a subset with sufficient presence/absence of NA values (ie limit number of NAs per level of 'grp').
Note :  optimal perfomance with n.lines >> n.groups
}
\examples{
dat1 <- matrix(1:56,nc=7)
dat1[c(2,3,4,5,6,10,12,18,19,20,22,23,26,27,28,30,31,34,38,39,50,54)] <- NA
rownames(dat1) <- letters[1:nrow(dat1)]
findUsableGroupRange(dat1,gl(3,3)[-(3:4)])
}
