% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameColumns.R
\name{renameColumns}
\alias{renameColumns}
\title{Rename columns}
\usage{
renameColumns(refMatr, newName, silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{refMatr}{matrix (or data.frame) where column-names should be changed}

\item{newName}{(matrix of character) giving correspondence of old to new names (number of lines must match number of columns of 'refMatr')}

\item{silent}{(logical) suppres messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a matrix (or data.frame) with renamed columns
}
\description{
This function renames columns of 'refMatr' using 2-column matrix (or data.frame) indicating old and new names (for replacement).
}
\examples{
ma <- matrix(1:8,ncol=4,dimnames=list(1:2,LETTERS[1:4]))
replBy1 <- cbind(new=c("dd","bb","z_"),old=c("D","B","zz"))
replBy2 <- matrix(c("D","B","zz","dd","bb","z_"),ncol=2)
replBy3 <- matrix(c("X","Y","zz","xx","yy","z_"),ncol=2)
renameColumns(ma,replBy1)
renameColumns(ma,replBy2)
renameColumns(ma,replBy3)
}
