% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowGrpCV.R
\name{.rowGrpCV}
\alias{.rowGrpCV}
\title{row group CV (main)}
\usage{
.rowGrpCV(x, grp, means)
}
\arguments{
\item{x}{numeric matrix where relplicates are organized into separate columns}

\item{grp}{(factor) defining which columns should be grouped (considered as replicates)}

\item{means}{(numeric) alternative values instead of means by .rowGrpMeans()}
}
\value{
This function returns a matrix of CV values
}
\description{
This function calculates CVs for matrix with multiple groups of data, ie one CV for each group of data.
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
grp1 <- gl(4,3,labels=LETTERS[1:4])[2:11]
head(.rowGrpCV(dat1, grp1,  .rowGrpMeans(dat1, grp1)))
}
\seealso{
\code{\link{rowGrpCV}}, \code{\link{rowCVs}}, \code{\link{arrayCV}}, \code{\link{replPlateCV}}
}
