% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterNetw.R
\name{.filterNetw}
\alias{.filterNetw}
\title{Filter nodes & edges for extracting networks (main)
 
This function allows extracting and filtering network-data based on fixed threshold (\code{limInt}) and add sandwich-nodes (nodes inter-connecting initial nodes) out of node-based queries.}
\usage{
.filterNetw(
  lst,
  remOrphans = TRUE,
  reverseCheck = TRUE,
  filtCol = 2,
  callFrom = NULL,
  silent = FALSE,
  debug = FALSE
)
}
\arguments{
\item{lst}{(list, composed of multiple matrix or data.frames ) main input (each list-element should have same number of columns)}

\item{remOrphans}{(logical) remove networks consisting only of 2 connected edges}

\item{reverseCheck}{(logical)}

\item{filtCol}{(integer, length=1) which column of \code{lst} should be usd to filter using thresholds \code{limInt} and \code{sandwLim}}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns a matrix or data.frame
}
\description{
Filter nodes & edges for extracting networks (main)
 
This function allows extracting and filtering network-data based on fixed threshold (\code{limInt}) and add sandwich-nodes (nodes inter-connecting initial nodes) out of node-based queries.
}
\examples{
ab <- 1:10  
}
\seealso{
\code{\link{filterNetw}} and other CRAN package dedeicated to networks
}
