% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponNormalize.R
\name{exponNormalize}
\alias{exponNormalize}
\title{Normalize by adjusting exponent}
\usage{
exponNormalize(
  dat,
  useExpon,
  dynExp = TRUE,
  nStep = 20,
  startExp = 1,
  simMeas = "cor",
  refDat = NULL,
  refGrp = NULL,
  refLines = NULL,
  rSquare = FALSE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{matrix or data.frame of numeric data to be normalized}

\item{useExpon}{(numeric vector or matrix) exponent values to be tested}

\item{dynExp}{(logical) require 'useExpon' as 2 values (matrix), will gradually increase exponent from 1st to 2nd; may be matrix or data.frame for dynamic, 
in this case 1st line for exp for lowest data, 2nd line for highest}

\item{nStep}{(integer) number of exponent variations (steps) when testing range from-to}

\item{startExp}{(numeric)}

\item{simMeas}{(character) similarity metric to be used (so far only "cor"), if rSquare=TRRUE, the r-squared will be returned}

\item{refDat}{(matrix or data.frame) if null average of each line from 'dat' will be used as reference in similarity measure}

\item{refGrp}{(factor) designing which col of 'ref' should be used with which col of 'dat' (length equal to number of cols in 'dat').
Note: 'refGrp' not yet coded optimally to extract numeric part of character vector, protential problems when all lines or cols of dat are NA}

\item{refLines}{(NULL or integer) optional subset of lines to be considered (only) when determining normalization factors}

\item{rSquare}{(logical) if \code{TRUE}, add r-squared}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This functuion returns a matrix of normalized data
}
\description{
This function normalizes 'dat' by optimizing exponent function (ie dat ^exp) to fit best to 'ref' (default: average of each line of 'dat').
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),nc=10)
head(rowGrpCV(dat1,gr=gl(4,3,labels=LETTERS[1:4])[2:11]))
set.seed(2016); dat1 <- c(0.1,0.2,0.3,0.5)*rep(c(1,10),each=4)
dat1 <- matrix(round(c(sqrt(dat1),dat1^1.5,3*dat1+runif(length(dat1))),2),nc=3)
dat2a <- exponNormalize(dat1[,1],useExpon=2,nSte=1,refD=dat1[,3])
layout(matrix(1:2,nc=2))
plot(dat1[,1],dat1[,3],type="b",main="init",ylab="ref") 
plot(dat2a$datNor[,1],dat1[,3],type="b",main="norm",ylab="ref")
dat2b <- exponNormalize(dat1[,1],useExpon=c(1.7,2.3),nSte=5,refD=dat1[,3])
plot(dat1[,1],dat1[,3],type="b",main="init",ylab="ref")
plot(dat2b$datNor[,1],dat1[,3],type="b",main="norm",ylab="ref")

dat2c <- exponNormalize(dat1[,-3],useExpon=matrix(c(1.7,2.3,0.6,0.8),nc=2),nSte=5,refD=dat1[,3]);
plot(dat1[,1],dat1[,3],type="b",main="init",ylab="ref ")
plot(dat2c$datNor[,1],dat1[,3],type="b",main="norm 1",ylab="ref")
plot(dat1[,2],dat1[,3],type="b",main="init",ylab="ref")
plot(dat2c$datNor[,2],dat1[,3],type="b",main="norm 2",ylab="ref"); 
}
\seealso{
more eveolved than \code{\link[wrMisc]{normalizeThis}} with arugment set to 'exponent'
}
