% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonRedundLines.R
\name{nonRedundLines}
\alias{nonRedundLines}
\title{Non-redundant lines of matrix}
\usage{
nonRedundLines(dat, callFrom = NULL)
}
\arguments{
\item{dat}{(matrix or data.frame) main input}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix (or data.frame) without repeated lines (keep 1st occurance)..
}
\description{
\code{nonRedundLines} reduces complexity of matrix (or data.frame) if multiple consectuive (!) lines with same values.
Return matrix (or data.frame) without repeated lines (keep 1st occurance)
}
\examples{
mat2 <- matrix(rep(c(1,1:3,3,1),2),ncol=2,dimnames=list(letters[1:6],LETTERS[1:2]))
nonRedundLines(mat2)
}
\seealso{
\code{\link{firstLineOfDat}}, \code{\link{firstOfRepLines}}, \code{\link{findRepeated}}, \code{\link{firstOfRepeated}}, \code{\link{get1stOfRepeatedByCol}}, \code{\link{combineRedBasedOnCol}}, \code{\link{correctToUnique}}
}
