% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiCharReplace.R
\name{multiCharReplace}
\alias{multiCharReplace}
\title{Multiple replacement of entire character elements in simple vector, matrix or data.frame}
\usage{
multiCharReplace(mat, repl, convTo = NULL, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{mat}{(character vector, matrix or data.frame) main data}

\item{repl}{(matrix or list) tells what to replace by what: If matrix the 1st oolumn will be considered as 'old' and the 2nd as 'replaceBy'; if named list, the names of the list-elements will be consdered as 'replaceBy'}

\item{convTo}{(character) optional conversion of content to 'numeric' or 'logical'}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
object of same dimension as input (with replaced content)
}
\description{
This functions allows multiple types of replacements of entire character elements in simple vector, matrix or data.frame. 
In addtion, the result may be optionally directly transformed to logical or numeric
}
\examples{
x1 <- c("ab","bc","cd","efg","ghj")
multiCharReplace(x1, cbind(old=c("bc","efg"), new=c("BBCC","EF")))

x2 <- c("High","n/a","High","High","Low")
multiCharReplace(x2, cbind(old=c("n/a","Low","High"), new=c(NA,FALSE,TRUE)),convTo="logical")

# works also to replace numeric content : 
x3 <- matrix(11:16, ncol=2)
multiCharReplace(x3,cbind(12:13,112:113))
}
\seealso{
\code{\link[base]{grep}}
}
