% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimRedundText.R
\name{trimRedundText}
\alias{trimRedundText}
\title{Trim redundant text}
\usage{
trimRedundText(
  txt,
  minNchar = 1,
  side = "both",
  spaceElim = FALSE,
  silent = TRUE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{txt}{character vector to be treated}

\item{minNchar}{(integer) minumin number of characters that must remain}

\item{side}{(character) may be be either 'both', 'left' or 'right'}

\item{spaceElim}{(logical) optional removal of any heading or tailing white space}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns a modified character vector
}
\description{
This function allows trimming/removing redundant text-fragments (redundant from head or tail) out of chracter vector 'txt'.
}
\examples{
x <- c("abcd","abcde","abcdefg","abcdE",NA,"abcdEF")
trimRedundText(x)

}
