% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixNAneighbourImputet.R
\name{matrixNAneighbourImpute}
\alias{matrixNAneighbourImpute}
\title{Impute random values to NAs in matrix based on replicates (neighbour) values}
\usage{
matrixNAneighbourImpute(dat, gr, retnNA = TRUE, avSdH = c(0.18, 0.5),
  avSdL = c(0.1, 0.5), plotHist = TRUE, xLab = NULL, tit = NULL,
  seedNo = 2018, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(matrix or data.frame) main data (may contain \code{NA})}

\item{gr}{(character or factor) grouping of columns of 'dat', replicate association}

\item{retnNA}{(logical) decide if NA values should be removed or retained}

\item{avSdH}{(numerical,length=2) population characteristics 'high' (mean and sd) for >1 \code{NA}-neighbours (per line)}

\item{avSdL}{(numerical,length=2) population characteristics 'low' (mean and sd) for >0 \code{NA}-neighbours}

\item{plotHist}{(logical) decide if supplemental figure with histogram shoud be drawn}

\item{xLab}{(character) label on x-axis on plot}

\item{tit}{(character) title on plot}

\item{seedNo}{(integer) seed-value for normal random values}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list with \code{$data} .. matrix of data where \code{NA} are replaced by imputed values, \code{$nNA} .. number of \code{NA} by group, \code{$randParam} .. parameters used for making random data
}
\description{
\code{matrixNAneighbourImpute} replaces \code{NA}-values based on group neigbours (based on grouping of columns in argument \code{gr}), assuming a Gaussian distribution.
If a given element was measured twice (eg in two replicate measurements), and one of these measurements revealed a \code{NA} while the other one gave a (finite) numeric value, 
the non-NA-value is considered a \code{NA}-neighbour.
The sub-population of these \code{NA}-neighbour values may be used to investigate the hypothesis that \code{NA}-values arose from very low signal. 
Indeed, in a number of experimental settings some actual measurements may not meet an arbitrary defined baseline (as 'zero') or may be too low to be distinguishable from noise that 
associated measures were initially recorded as \code{NA}. In several types of (quantitative) measurments in proteomics and transcriptomics this is known to happen.
So this function allows to model and subsequently replace all \code{NA}-values by Gaussian random values based on the characteristics of \code{NA}-neighbours in the same data-set.
However, defining these characteristics (via the arguments \code{avSdH} and \code{avSdL}) may be very delicate and visual verification of the plots produced is highly encouraged ! 
If more than 300 \code{NA}-neighbours were detected, the imputation will be based on a more restricted sub-set of data with >1 \code{NA} values. 
Optionally a histogram may be plotted showing the initial, imputed and final distribution to check if the global hypothesis that \code{NA}-values arose from very low measurements and 
to appreciate the impact of the imputed values to the overall final distribution.
Of course, all decisions to replace \code{values} do have a strong impact on further steps of data-analysis and should be performed with care.
}
\examples{
set.seed(2013)
datT6 <- matrix(round(rnorm(300)+3,1),ncol=6,dimnames=list(paste("li",1:50,sep=""),
  letters[19:24]))
datT6 <- datT6 +matrix(rep(1:nrow(datT6),ncol(datT6)),ncol=ncol(datT6))
datT6[6:7,c(1,3,6)] <- NA
datT6[which(datT6 < 11 & datT6 > 10.5)] <- NA
datT6[which(datT6 < 6 & datT6 > 5)] <- NA
datT6[which(datT6 < 4.6 & datT6 > 4)] <- NA
datT6b <- matrixNAneighbourImpute(datT6,gr=gl(2,3))
head(datT6b$data)
}
\seealso{
\code{\link[graphics]{hist}}, \code{\link[stats]{na.fail}},  \code{\link[wrMisc]{naOmit}}
}
