% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readProteomeDiscovererFile.R
\name{.checkSetupGroups}
\alias{.checkSetupGroups}
\title{Additional/final chek and adjustments to sample-order after readSampleMetaData()}
\usage{
.checkSetupGroups(
  abund,
  setupSd,
  gr = NULL,
  sampleNames = NULL,
  quantMeth = NULL,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{abund}{(matrix or data.frame) abundance data, only the colnames will be used}

\item{setupSd}{(list) describing sammple-setup, typically produced by   from package wrMisc}

\item{gr}{(factor) optional custom information about replicate-layout, has priority over setuoSd}

\item{sampleNames}{(character) custom sample-names, has priority over abund and setuoSd}

\item{quantMeth}{(character) 2-letter abbreviation of name of quantitation-software (eg 'MQ')}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns an enlaged/updated list 'setupSd' (set setupSd$sampleNames,  setupSd$groups)
}
\description{
This (low-level) function performs an additional/final chek & adjustments to sample-names after readSampleMetaData()
}
\examples{
set.seed(2021)
}
\seealso{
used in \code{readProtDiscovererFile},  \code{\link{readMaxQuantFile}}, \code{\link{readProlineFile}}, \code{\link{readFragpipeFile}}
}
