% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixNAinspect.R
\name{matrixNAinspect}
\alias{matrixNAinspect}
\title{Histogram of content of NAs in matrix}
\usage{
matrixNAinspect(
  dat,
  gr = NULL,
  retnNA = TRUE,
  xLab = NULL,
  tit = NULL,
  xLim = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main numeric data}

\item{gr}{(charcter or factor) grouping of columns of dat indicating who is a replicate of whom (ie the length of 'gr' must be equivalent to the number of columns in 'dat')}

\item{retnNA}{(logical) report number of NAs in graphic}

\item{xLab}{(character) custom x-label}

\item{tit}{(character) custom title}

\item{xLim}{(numerical,length=2) custom x-axis limits}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function produces a graphic (to the current graphical device)
}
\description{
\code{matrixNAinspect} makes histograms of the full data and shows sub-population of \code{NA}-neighbour values.  
The aim of this function is to investigate the nature of \code{NA} values in matrix (of experimental measures) where replicate measurements are available.
If a given element was measured twice, and one of these measurements revealed a \code{NA} while the other one gave a (finite) numeric value, the non-NA-value is considered a \code{NA}-neighbour.  
The subpopulation of these \code{NA}-neighbour values will then be highlighted in the resulting histogram.
In a number of experimental settiongs some actual measurements may not meet an arbitrary defined baseline (as 'zero') or may be too low to be distinguishable from noise that 
associated measures were initially recorded as \code{NA}. In several types of measurments in proteomics and transcriptomics this may happen.
So this fucntion allows to collect all \code{NA}-neighbour values and compare them to the global distribution of the data to investigate if \code{NA}-neighbours are typically very low values.
In case of data with multiple replicates \code{NA}-neighbour values may be distinguished for the case of 2 \code{NA} per group/replicate-set.
The resulting plots are typically used to decide if and how \code{NA} values may get replaced by imputed random values or wether measues containing \code{NA}-values should rather me omitted.
Of course, such decisions do have a strong impact on further steps of data-analysis and should be performed with care.
}
\examples{
set.seed(2013)
datT6 <- matrix(round(rnorm(300)+3,1), ncol=6, 
  dimnames=list(paste("li",1:50,sep=""), letters[19:24]))
datT6 <- datT6 +matrix(rep(1:nrow(datT6),ncol(datT6)), ncol=ncol(datT6))
datT6[6:7,c(1,3,6)] <- NA
datT6[which(datT6 < 11 & datT6 > 10.5)] <- NA
datT6[which(datT6 < 6 & datT6 > 5)] <- NA
datT6[which(datT6 < 4.6 & datT6 > 4)] <- NA
matrixNAinspect(datT6, gr=gl(2,3)) 
}
\seealso{
\code{\link[graphics]{hist}}, \code{\link[stats]{na.fail}}, \code{\link[wrMisc]{naOmit}}
}
