% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{pairwise_wilcox_test}
\alias{pairwise_wilcox_test}
\title{Pairwise Wilcoxon tests}
\usage{
pairwise_wilcox_test(
  dep_var,
  indep_var,
  strat_var = NA,
  adjmethod = "fdr",
  distr = "exact",
  plevel = 0.05,
  symbols = letters[-1],
  sep = ""
)
}
\arguments{
\item{dep_var}{dependent variable, containing the data.}

\item{indep_var}{independent variable, should be factor.}

\item{strat_var}{optional factor for stratification.}

\item{adjmethod}{method for adjusting p values (see \link{p.adjust})}

\item{distr}{Computation of p-values, see \link{wilcox_test}.}

\item{plevel}{threshold for significance.}

\item{symbols}{predefined as b,c, d...;  provides footnotes to mark group
differences, e.g. b means different from group 2.}

\item{sep}{text between statistics and range or other elements.}
}
\value{
A list with matrix of adjusted p-values and character vector with significance indicators.
}
\description{
\code{pairwise_wilcox_test} calculates pairwise comparisons on ordinal data
between all group levels with corrections for multiple testing based on
\link{wilcox_test} from package 'coin'.
}
\examples{
pairwise_wilcox_test(dep_var = mtcars$wt, indep_var = mtcars$cyl)
}
