% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{qchar_frame}
\alias{qchar_frame}
\title{Build a (non-empty) quoted data.frame.}
\usage{
qchar_frame(...)
}
\arguments{
\item{...}{cell names, first infix operator denotes end of header row of column names.}
}
\value{
character data.frame
}
\description{
A convenient way to build a character data.frame in legible transposed form.  Position of
first "|" (or other infix operator) determines number of columns
(all other infic operators are aliases for ",").
Names are treated as character types.
}
\examples{

x <- qchar_frame(
   measure,                      training, validation |
   "minus binary cross entropy", loss,     val_loss   |
   accuracy,                     acc,      val_acc    )
print(x)
str(x)
cat(draw_frame(x))

qchar_frame(
  x |
  1 |
  2 )

}
\seealso{
\code{\link{draw_frame}}, \code{\link{build_frame}}
}
