% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mk_formula.R
\name{mk_formula}
\alias{mk_formula}
\title{Construct a formula.}
\usage{
mk_formula(outcome, variables, ..., intercept = TRUE, env = baseenv())
}
\arguments{
\item{outcome}{character scalar, name of outcome or dependent variable.}

\item{variables}{character vector, names of input or independent variables.}

\item{...}{not used, force later arguments to bind by name.}

\item{intercept}{logical, if TRUE allow an intercept term.}

\item{env}{environment to use in formula.}
}
\value{
a formula object
}
\description{
Safely construct a formula from the outcome (dependent variable) name
and vector of input (independent variable) names.
}
\details{
Note: outcome and variables
are each intended to be simple variable names or column names (or .). They are not
intended to specify
interactions, I()-terms, transforms, general experessions or other complex formula terms.
Essentially the same effect as \code{\link[stats]{reformulate}}, but trying to avoid the
\code{paste} currently in \code{\link[stats]{reformulate}} by calling \code{\link[stats]{update.formula}}
(which appears to work over terms).
Another reasonable way to do this is just \code{paste(outcome, paste(variables, collapse = " + "), sep = " ~ ")}.
}
\examples{

f <- mk_formula("mpg", c("cyl", "disp"))
print(f)
lm(f, mtcars)

}
\seealso{
\code{\link[stats]{reformulate}}, \code{\link[stats]{update.formula}}
}
