% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack.R
\name{to}
\alias{to}
\title{Unpack or bind values by names into the calling environment, eager eval (no-dot) variation.}
\usage{
to(...)
}
\arguments{
\item{...}{argument names to write to}
}
\value{
a UnpackTarget
}
\description{
Unpacks or binds values into the calling environment, eager eval (no-dot) variation. Uses \code{bquote} escaping.
NULL is a special case that is unpacked to all targets. NA targets are skipped.
All non-NA target names must be unique.
}
\details{
Note: when using \code{[]<-} notation, a reference to the unpacker object is written into the unpacking environment as a side-effect
of the implied array assignment. \code{:=} assigment does not have this side-effect.
Array-assign form can not use the names: \code{.}, \code{wrapr_private_self}, \code{value}, or \code{to}.
function form can not use the names: \code{.} or \code{wrapr_private_value}.
For more detials please see here \url{http://www.win-vector.com/blog/2020/01/unpack-your-values-in-r/}.

Related work includes \code{Python} tuple unpacking, \code{zeallot}'s arrow, and \code{vadr::bind}.
}
\examples{

# named unpacking
# looks like assignment: DESTINATION = NAME_VALUE_USING
d <- data.frame(x = 1:2,
                g=c('test', 'train'),
                stringsAsFactors = FALSE)
to[train_set = train, test_set = test] := split(d, d$g)
# train_set and test_set now correctly split
print(train_set)
print(test_set)
rm(list = c('train_set', 'test_set'))

# named unpacking NEWNAME = OLDNAME implicit form
# values are matched by name, not index
to[train, test] := split(d, d$g)
print(train)
print(test)
rm(list = c('train', 'test'))

# pipe version (notice no dot)
split(d, d$g) \%.>\% to(train, test)
print(train)
print(test)
rm(list = c('train', 'test'))
# Note: above is wrapr dot-pipe, piping does not currently work with
# magrittr pipe due to magrittr's introduction of temporary
# intermediate environments during evaluation.

# bquote example
train_col_name <- 'train'
test_col_name <- 'test'
to[train = .(train_col_name), test = .(test_col_name)] := split(d, d$g)
print(train)
print(test)
rm(list = c('train', 'test'))

}
