% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qae.R
\name{qae}
\alias{qae}
\title{Quote assignment expressions (name = expr, name := expr, name \%:=\% expr).}
\usage{
qae(...)
}
\arguments{
\item{...}{assignment expressions.}
}
\value{
array of quoted assignment expressions.
}
\description{
Accepts arbitrary un-parsed expressions as
assignments to allow forms such as "Sepal_Long := Sepal.Length >= 2 * Sepal.Width".
(without the quotes).
Terms are expressions of the form "lhs := rhs", "lhs = rhs", "lhs \%:=\% rhs".
}
\details{
\code{qae()} uses
\code{bquote()} \code{.()} quasiquotation escaping notation,
and \code{.(-)} "string quotes, string to name" notation.
}
\examples{

ratio <- 2

exprs <- qae(Sepal_Long := Sepal.Length >= ratio * Sepal.Width,
             Petal_Short = Petal.Length <= 3.5)
print(exprs)

exprs <- qae(Sepal_Long := Sepal.Length >= .(ratio) * Sepal.Width,
             Petal_Short = Petal.Length <= 3.5)
print(exprs)

# library("rqdatatable")
# datasets::iris \%.>\%
#  extend_se(., exprs) \%.>\%
#  summary(.)

}
\seealso{
\code{\link{qc}}, \code{\link{qe}}
}
