% Generated by roxygen2 (4.0.2): do not edit by hand
\name{acfana}
\alias{acfana}
\title{acfana}
\usage{
acfana(listOfFiles = NULL, optLogFilePath = NULL, beginTime = 0,
  centerTime = FALSE, endTime = 0, windowShift = 5, windowSize = 20,
  effectiveLength = TRUE, window = "BLACKMAN", analysisOrder = 0,
  energyNormalization = FALSE, lengthNormalization = FALSE, toFile = TRUE,
  explicitExt = NULL, outputDirectory = NULL,
  forceToLog = useWrasspLogger)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds (default: 0 = beginning of file)}

\item{centerTime}{= <time>: set single-frame analysis with the analysis window centred at <time> seconds;
overrules BeginTime, EndTime and WindowShift options}

\item{endTime}{= <time>: set end of analysis interval to <time> seconds (default: 0 = end of file)}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms (default: 5.0)}

\item{windowSize}{= <dur>: set analysis window size to <dur> ms; overrules EffectiveLength parameter}

\item{effectiveLength}{make window size effective rather than exact}

\item{window}{= <type>: set analysis window function to <type> (default: BLACKMAN)}

\item{analysisOrder}{= <num>: set analysis order to <num> (default: 0 = sample rate in kHz + 3)}

\item{energyNormalization}{calculate energy-normalized autocorrelation}

\item{lengthNormalization}{calculate length-normalized autocorrelation}

\item{toFile}{write results to file (default extension is .acf)}

\item{explicitExt}{set if you wish to overwride the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}
}
\value{
nrOfProcessedFiles or if only one file to process return AsspDataObj of that file
}
\description{
acfana function adapted from libassp
}
\details{
Analysis of short-term autocorrelation function of
the signals in <listOFFiles>.
Analysis results will be written to a file with the
base name of the input file and extension '.acf'.
Default output is in SSFF binary format (track 'acf').
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"),
                       pattern = glob2rx("*.wav"),
                       full.names = TRUE)[1]

# calculate short-term autocorrelation
res <- acfana(path2wav, toFile=FALSE)

# plot short-term autocorrelation values
matplot(seq(0,numRecs.AsspDataObj(res) - 1) / rate.AsspDataObj(res) +
        attr(res, 'startTime'),
        res$acf,
        type='l',
        xlab='time (s)',
        ylab='short-term autocorrelation values')
}
\author{
Raphael Winkelmann

Lasse Bombien
}

