% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afdiff.R
\name{afdiff}
\alias{afdiff}
\title{afdiff}
\usage{
afdiff(
  listOfFiles = NULL,
  optLogFilePath = NULL,
  computeBackwardDifference = FALSE,
  computeCentralDifference = FALSE,
  channel = 1,
  toFile = TRUE,
  explicitExt = NULL,
  outputDirectory = NULL,
  forceToLog = useWrasspLogger,
  verbose = TRUE
)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{computeBackwardDifference}{compute backward difference (s'[n] = s[n] - s[n-1]) (default: forward difference s'[n] = s[n+1] - s[n])}

\item{computeCentralDifference}{compute central/interpolated/3-point difference}

\item{channel}{= <num>: for multi-channel input files: extract and differentiate channel <num> (1 <= <num> <= 8  default: channel 1)}

\item{toFile}{write results to file (default extension is .d+(extensionsOfAudioFile))}

\item{explicitExt}{set if you wish to override the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e. 
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return AsspDataObj of that file
}
\description{
afdiff function adapted from libassp
}
\details{
Computes the first difference of the signal in the audio-
formatted file(s) <listOfFiles>. The differentiated signal will
be written to a file with the base name of the input file
and an extension consisting of '.d', followed by the
extension of the input file. The format of the output file
will be the same as that of the input file.
Differentiation can improve results on F0 analysis of e.g.
EGG signals because it removes a DC offset, attenuates
very low frequency components - and in the case of central
differentiation also very high ones - and enhances the
moment of glottal closure.
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# compute the first forward difference of the signal
res <- afdiff(path2wav, toFile=FALSE)

# plot samples
# (only plot every 10th element to accelerate plotting)
plot(seq(0,numRecs.AsspDataObj(res) - 1, 10) / rate.AsspDataObj(res), 
     res$audio[c(TRUE, rep(FALSE,9))], 
     type='l', 
     xlab='time (s)', 
     ylab='Audio samples')
     
}
\author{
Raphael Winkelmann

Lasse Bombien
}
