% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCensusData.R
\name{getCensusData}
\alias{getCensusData}
\title{Title return
Multilevel Census Data download function.}
\usage{
getCensusData(key, states, demo = FALSE)
}
\arguments{
\item{key}{A required character object. Must contain user's Census API
key, which can be requested \href{http://api.census.gov/data/key_signup.html}{here}.}

\item{states}{which states to extract 
Census data for, e.g. \code{c("NJ", "NY")}.}

\item{demo}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on 
demographics (i.e., age and sex) or not. If \code{TRUE}, function will return 
Pr(Geolocation, Age, Sex | Race). If \code{FALSE}, function wil return 
Pr(Geolocation | Race). Default is \code{FALSE}.}
}
\value{
Output will be an census object of class which is a list consist of \code{state}, 
\code{demo}, \code{county level census}, \code{tract level census} and \code{block level census}. 
Have the census data available could make \code{census.helper.api} runs more efficient.
}
\description{
\code{getCensusData} returns a Census data obj for a state.
}
\examples{
\dontrun{getCensusData(key = "...", states = c("NJ", "DE"), demo = TRUE)}
}

