% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_surnames.R
\name{merge_surnames}
\alias{merge_surnames}
\title{Surname probability merging function.}
\usage{
merge_surnames(voter.file, surname.year = 2010, clean.surname = T,
  impute.missing = T)
}
\arguments{
\item{voter.file}{An object of class \code{data.frame}. Must contain a field 
named 'surname' containing list of surnames to be merged with Census lists.}

\item{surname.year}{An object of class \code{numeric} indicating which year 
Census Surname List is from. Accepted values are \code{2010} and \code{2000}. 
Default is \code{2010}.}

\item{clean.surname}{A \code{TRUE}/\code{FALSE} object. If \code{TRUE}, 
\code{clean.surname} function will be run to clean raw surnames in 
\code{\var{voter.file}} before matching them with Census lists, 
in order to increase the chance of finding a match. 
See \code{clean.surname} documentation for details.
Default is \code{TRUE}.}

\item{impute.missing}{A \code{TRUE}/\code{FALSE} object. If \code{TRUE}, 
race/ethnicity probabilities will be imputed for unmatched names using  
race/ethnicity distribution for all other names (i.e., not on Census List).
Default is \code{TRUE}.}
}
\value{
Output will be an object of class \code{data.frame}. It will 
 consist of the original user-input data with additional columns that 
 specify the part of the name matched with Census data (\code{\var{surname.match}}), 
 and the probabilities Pr(Race | Surname) for each racial group 
 (\code{\var{p_whi}} for White, \code{\var{p_bla}} for Black, 
 \code{\var{p_his}} for Hispanic/Latino, 
 \code{\var{p_asi}} for Asian and Pacific Islander, and 
 \code{\var{p_oth}} for Other/Mixed).
}
\description{
\code{merge_surnames} merges surnames in user-input dataset with corresponding 
 race/ethnicity probabilities from U.S. Census Surname List and Spanish Surname List.
}
\details{
This function allows users to match surnames in their dataset with the U.S. 
 Census Surname List (from 2000 or 2010) and Spanish Surname List to obtain 
 Pr(Race | Surname) for each of the five major racial groups.
 
 By default, the function matches surnames to the Census list as follows 
 (each step only applies to surnames not matched in previous steps): 
 1) Search raw surnames in Census surname list; 
 2) Remove any punctuation and search again; 
 3) Remove any spaces and search again; 
 4) Remove suffixes (e.g., Jr) and search again; 
 5) Split double-barreled surnames into two parts and search first part of name; 
 6) Split double-barreled surnames into two parts and search second part of name; 
 7) For any remaining names, impute probabilities using distribution 
 for all names not appearing on Census list.
 
 Note: Any name appearing only on the Spanish Surname List is assigned a 
 probability of 1 for Hispanics/Latinos and 0 for all other racial groups.
}
\examples{
data(voters)
merge_surnames(voters)

}

