% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w.diagnosis.R
\name{w.diagnosis}
\alias{w.diagnosis}
\title{Plots for w values diagnosis}
\usage{
w.diagnosis(data, w.order = c(1, 2), n.rep = 10, n.sample = nrow(data),
  n.marker = ncol(data), hf1 = "default.hf1", hf2 = "default.hf2", ...)
}
\arguments{
\item{data}{a data frame or matrix contains genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1).}

\item{w.order}{an integer value of 0 or 1. w.order = 1 for main effect calculation; w.order = 2, for pairwise calculation.}

\item{n.rep}{a numeric value, the number of replicates.}

\item{n.sample}{a numeric value, the number of samples to use in bootstrapping. Default is the total number of samples in the data.}

\item{n.marker}{a numeric value, the number of markers to use in bootstrapping. Default is the total number of markers.}

\item{hf1}{a data frame or matrix, contains the h and f values for main effect (w.order =1) calculation at the number of categorical combinations (k) = 2 or 3. Default.hf1= array(c(0.5, 0.667, 1, 2), dim=c(2,2)), in which the first row is the h and f for k=2, and second row is the h and f for k=3.}

\item{hf2}{a data frame or matrix, contains the h and f values for pairwise interaction effect calculation (w.order=2) when k = 2 to 9. Default.hf2 = array(c(0.5, 0.667, 0.75, 0.8, 0.833, 0.857, 0.875, 0.889, 1:8), dim=c(8,2)), the first row is the h and f for k=2, and the last row is the h and f for k=9.}

\item{...}{graphical parameters.}
}
\description{
Function to plot the distribution of w values against its theoretical distribution for W-test diagnosis.
}
\details{
{This function evaluates the input w values of main or interaction effects using a set of null Y by the \code{W-test}, and plots the w values probabilities against its theoretical Chi-squared distribution density with f degrees of freedom indexed by k.
Since h and f are dataset adaptive, estimated hf is strongly recommended.}
}
\examples{
data(mydata)
hf1<-hf.calculation(data = mydata, w.order = 1, B = 100)
hf2<-hf.calculation(data = mydata, w.order = 2, B = 50)
w.diagnosis(mydata, w.order = 1, n.rep = 200, hf1 = hf1, main=NULL, xlab=NULL, ylab=NULL)
w.diagnosis(mydata, w.order = 2, n.rep = 100, hf2 = hf2, main=NULL, xlab=NULL, ylab=NULL)
}
\author{
Rui Sun, Maggie Haitian Wang
}
\references{
Maggie Haitian Wang, Rui Sun, Junfeng Guo, Haoyi Weng, Jack Lee, Inchi Hu, Pak Sham and Benny C.Y. Zee (2016). A fast and powerful W-test for pairwise epistasis testing. Nucleic Acids Research.doi:10.1093/nar/gkw347.
}
\seealso{
\code{\link{wtest}}, \code{\link{hf.calculation}}, \code{\link{w.qqplot}}
}

