% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtest.snps.meth.R
\name{wtest.snps.meth}
\alias{wtest.snps.meth}
\title{W-test for gene-methylation interaction analysis}
\usage{
wtest.snps.meth(geno, meth, y, geno.pos, meth.pos, window.size = 10000,
  hf = "default.hf", output.pval = NULL, sort = TRUE)
}
\arguments{
\item{geno}{a data frame or matrix contains genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1). SNP names should be stored at column names of the data.}

\item{meth}{a data frame or matrix contains methylation data in the columns. Methylation data should be recoded as (0, 1, 2) or (0, 1). Names of CpG sites should be stored at column names of the data.}

\item{y}{a numeric vector composed of 0 or 1; or a factor variable with two levels.}

\item{geno.pos}{a data frame contains SNP names and positions in two columns.}

\item{meth.pos}{a data frame contains CpG names and positions in two columns.}

\item{window.size}{a numeric number specifies the size of genome distance. Interaction effects of the SNPs and CpG sites located within the size of genome distance will be evaluated exhaustively.}

\item{hf}{a data frame or matrix, contains the \emph{h} and \emph{f} values for pairwise interaction effect calculation when \emph{k} = 2 to 9. Default \emph{hf} is \emph{h} = \emph{k}/(\emph{k}-1) and \emph{f} = \emph{k}-1, where \emph{k} = 2 to 9, the first row is the \emph{h} and \emph{f} for \emph{k} = 2, and the last row is the \emph{h} and \emph{f} for \emph{k} = 9.}

\item{output.pval}{a p-value threshold for filtering the output. If NULL, all the results will be listed; otherwise, the function will only output the results with p-values smaller than the output.pval.}

\item{sort}{a logical value indicating whether or not to sort the output by p-values in ascending order. Default = TRUE.}
}
\value{
An object \code{"wtest.snps.meth"} containing:

\item{results}{The test results include: SNP name, CpG name, SNP position, CpG position, W value, \emph{k}, and p-value.}

\item{hf}{The \emph{h} and \emph{f} values used for each \emph{k} in pairwise calculation, where \emph{k} = 2 to 9.}
}
\description{
{This function performs the \code{W-test} to calculate gene-methylation interactions at a (SNP,CpG) pair level for categorical
data sets and suitable for a genome-wide testing. This function can automatically screen and exhaustively evaluate interaction effects of
the SNPs and CpG sites located within a user-defined genome distance. The output can be filtered by p-values, such that only sets with smaller
p-value than a threshold (\code{output.pval}) will be returned.}
}
\details{
{W-test is a model-free statistical test to measure main effect or pairwise interactions in case-control studies with categorical variables.
Theoretically, the test statistic follows a Chi-squared distribution with \emph{f} degrees of freedom. The data-adaptive degree of freedom \emph{f},
and a scalar \emph{h} in the test statistics allow the W-test to correct for distributional bias due to sparse data and small sample size.
Let \emph{k} be the number of columns of the 2 by \emph{k} contingency table formed by a single variable or a variable pair.
When the sample size is large and there is no population stratification, the \emph{h} and \emph{f} will approximate well to the theoretical
value \emph{h} = (\emph{k}-1)/\emph{k}, and \emph{f} = \emph{k}-1. When sample size is small and there is population stratification, the \emph{h} and
\emph{f} will vary to correct for distributional bias caused by the data structure.}
}
\examples{
data(SNP_pos)
data(CpG_pos)
data(genotype)
data(methylation)
data(phenotype2)

w <- 13000

# Recode methylation data
methylation <- methylation.recode(methylation)

## Step 1. HF Calculation.
# Please note that parameter B is recommended to be greater than 400.
hf.pair <- hf.snps.meth(B = 80, geno = genotype, meth = methylation, y = phenotype2,
                        geno.pos = SNP_pos, meth.pos = CpG_pos, window.size = w)

## Step 2. Application
result <- wtest.snps.meth(geno = genotype, meth = methylation, y = phenotype2, geno.pos = SNP_pos,
                          meth.pos = CpG_pos, window.size = w, hf = hf.pair, output.pval = 0.1)

}
\references{
Maggie Haitian Wang, Rui Sun, Junfeng Guo, Haoyi Weng, Jack Lee, Inchi Hu, Pak Sham and Benny C.Y. Zee (2016). A fast and powerful W-test for pairwise epistasis testing. Nucleic Acids Research.doi:10.1093/nar/gkw347.
}
\seealso{
\code{\link{wtest}}, \code{\link{hf.snps.meth}}
}
\author{
Rui Sun, Maggie Haitian Wang
}
