% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_x3p.R
\name{x3p_sample}
\alias{x3p_sample}
\alias{sample_x3p}
\title{Sample from an x3p object}
\usage{
x3p_sample(x3p, m = 2, mY = m, offset = 0, offsetY = offset)

sample_x3p(x3p, m = 2, mY = m, offset = 0, offsetY = offset)
}
\arguments{
\item{x3p}{x3p object}

\item{m}{integer value - every mth value is included in the sample}

\item{mY}{integer value - every mth value is included in the sample in x direction and every mYth value is included in y direction}

\item{offset}{integer value between 0 and m-1 to specify offset of the sample}

\item{offsetY}{integer value between 0 and mY-1 to specify different offsets for x and y direction}
}
\value{
down-sampled x3p object
}
\description{
Sample from an x3p object
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
dim(logo$surface.matrix)
# down-sample to one-fourth of the image:
logo4 <- x3p_sample(logo, m=4)
dim(logo4$surface.matrix)
\dontrun{
x3p_image(logo)
x3p_image(logo4)
}
}
