% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMask.R
\name{addMask}
\alias{addMask}
\title{Plot or add a mask}
\usage{
addMask(mask, add = TRUE, col = "black")
}
\arguments{
\item{mask}{a binary or logical matrix, describing the mask (0:black for selected pixels, 1:white for not selected pixels)}

\item{add}{a logical variable, whether to add the mask to an existing plot}

\item{col}{a character string, color value of the plotted mask}
}
\description{
This function plots or adds a mask raster on the default graphics.
}
\examples{

#read a mask file in TIFF format
m <- tiff::readTIFF(system.file(package = 'xROI', 'dukehw-mask.tif'))
str(m)

#plot the mask in black color
addMask(m, add = FALSE)

#add the same mask in the red color to the existing plot
addMask(m, add = TRUE, col = 'red')

}
\keyword{mask}
\keyword{plot}
\keyword{raster}
